#!/usr/bin/env python
import myautomata
import numpy as np
import matplotlib.pyplot as plt
    
# takes image matrix an fills a line at index
def fill_line(image,x,index,width):
    for i in xrange(width):
        xx = pick_color(int(x[i]))
        image[index][i] = xx

# fills whole image using width and height, the burnin is allow
# a few cycles of the algorithms before we visualize them
def fill_image(image,width,height,burnin):
    x = myautomata.gfp(width) # start with first pattern
    for i in xrange(burnin):  # burnin (throw a way cycles)
        x = myautomata.gp(x)  # get next new pattern and overwrite the old line vector
    for i in range(height):   # now collecting results
        x = myautomata.gp(x)  # new line pattern
        fill_line(image,x,i,width) # insert line pattern into image 

def pick_color(i):
    # returns x which is a list of
    # RGB color + alpha channel
    # [Red, Green, Blue, Alpha]
    # the values are between 0 and 1
    # this is bright red: [1, 0, 0,1]
    if i==0:
        x = [0.1,0,0,1] # is redish black
    else:
        x = [0.9,0.4,0,1] # this is yellowish orange-brown
    return x

if __name__ == '__main__':
    w=300
    h=400
    image = np.empty((w,h,4),np.float32)
    fill_image(image,h,w,200)
    ii=plt.imshow(image,interpolation='none', extent=[0,w,0,h],aspect='auto') 
    plt.show()



