#import <vector>
#import <iostream>
#import "cautomata.h"

std::vector<int> generate_start_pattern (const int n)
{
  std::vector<int> v(n,0);  // create vector of zeroes
  v[n/2]=1; // set middle value to 1
  return v;
}

std::vector<int> generate_new_pattern (const std::vector<int> v)
{
  //  current pattern          111 110 101 100 011 010 001 000
  //  new state for center cell 0   0   0   1   1   1   1   0

  std::vector<int>::const_iterator it; 
  std::vector<int>::iterator nit; 
  std::vector<int> newv(v);
  for(it=v.begin()+1, nit=newv.begin()+1; it < v.end()-1; it++, nit++) 
    { 
      int value = 100 * *(it-1);
      value  +=  10 * *it;
      value  += *(it+1);
      if (value==100 || value==1 || value==10 || value==11)
	*nit = 1;
      else
	*nit = 0;
    }
  return newv;
}

void print(const std::vector<int> v)
{
  for( std::vector<int>::const_iterator it = v.begin(); it != v.end(); ++it)
    std::cout << *it;
  std::cout << std::endl;
}


int main(int argc,char **argv)
{
  if (argc <= 1)
    {
      std::cout << "Syntax: automata #numberofcolumns" << std::endl;
      return -1;
    }
  int n = atoi(argv[1]);
  std::vector<int> v = generate_start_pattern (n);
  print(v);
  for(int i=0;i<30;++i)
    {
      v = generate_new_pattern (v);
      print(v);
    }
  return 0;
}

